<?php
require __DIR__ . '/../config.php';

// Grab id from query (?id=XYZ) set by .htaccess rewrite
$id = $_GET['id'] ?? '';
$payload = null;
$title = 'Shared Insight — Ask The Word';
$desc  = 'Tap to open in the app. Includes verse, question, and explanation.';

// Try to fetch payload to craft OG tags (optional but nice)
if (is_valid_id($id)) {
    try {
        $db = pdo();
        $stmt = $db->prepare(
          'SELECT payload_json,
                  (expires_at IS NULL OR expires_at > UTC_TIMESTAMP()) AS not_expired,
                  status
           FROM links WHERE id = ? LIMIT 1'
        );
        $stmt->execute([$id]);
        if ($row = $stmt->fetch()) {
            if ($row['status'] === 'active' && $row['not_expired']) {
                $payload = json_decode($row['payload_json'], true);
                if (is_array($payload)) {
                    // Build nicer title/description for preview
                    $ref = $payload['ref'] ?? null;
                    $refStr = '';
                    if (is_array($ref)) {
                        $refStr = ($ref['book'] ?? '') . ' ' . ($ref['chapter'] ?? '');
                        if (isset($ref['startVerse'])) {
                            $refStr .= ':' . $ref['startVerse'];
                            if (isset($ref['endVerse']) && $ref['endVerse'] !== $ref['startVerse']) {
                                $refStr .= '-' . $ref['endVerse'];
                            }
                        }
                    }
                    if ($refStr) $title = $refStr . ' — Shared Insight';
                    if (!empty($payload['question'])) {
                        $desc = $payload['question'];
                    }
                }
            }
        }
    } catch (Throwable $e) { /* ignore and use defaults */ }
}

$shortUrl = SHORT_DOMAIN . '/s/' . htmlspecialchars($id, ENT_QUOTES);
$iconUrl  = 'https://snickitybit.com/assets/asktheword-icon.png';
$cardUrl  = 'https://snickitybit.com/assets/asktheword-card.png';
// Your public App Store link:
$appStore = 'https://apps.apple.com/us/app/ask-the-word/id6754179331';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title><?= htmlspecialchars($title) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <!-- Smart App Banner -->
  <meta name="apple-itunes-app" content="app-id=6754179331, app-argument=<?= htmlspecialchars($shortUrl) ?>">

  <!-- Open Graph / Twitter for nice unfurls -->
  <meta property="og:title" content="<?= htmlspecialchars($title) ?>">
  <meta property="og:description" content="<?= htmlspecialchars($desc) ?>">
  <meta property="og:image" content="<?= htmlspecialchars($cardUrl) ?>">
  <meta property="og:url" content="<?= htmlspecialchars($shortUrl) ?>">
  <meta name="twitter:card" content="summary_large_image">

  <style>
    body { font-family: system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif; margin:0; padding:24px; background:#fafafa; color:#222; }
    .card { max-width: 820px; margin: 0 auto; background:#fff; border-radius: 14px; padding: 24px; box-shadow: 0 10px 30px rgba(0,0,0,.06); }
    h1 { font-size: 20px; margin: 0 0 8px; }
    .sub { color:#666; font-size: 14px; margin-bottom: 16px; }
    .q { font-weight: 600; font-size: 18px; margin: 16px 0 8px; }
    .a { white-space: pre-wrap; line-height: 1.5; }
    .btns { display:flex; gap:12px; margin-top: 20px; flex-wrap: wrap; }
    .btn { appearance:none; border:0; padding:12px 16px; border-radius:10px; cursor:pointer; font-weight:600; text-decoration:none; }
    .primary { background:#0a84ff; color:#fff; }
    .ghost { background:#f3f4f6; color:#111; }
  </style>
</head>
<body>
  <div class="card">
    <h1><?= htmlspecialchars($title) ?></h1>
    <p class="sub"><?= htmlspecialchars($desc) ?></p>

    <?php if ($payload): ?>
      <div class="q"><?= htmlspecialchars($payload['question'] ?? '') ?></div>
      <div class="a"><?= nl2br(htmlspecialchars($payload['answer'] ?? '')) ?></div>
    <?php else: ?>
      <p>This shared item may be expired or revoked.</p>
    <?php endif; ?>

    <div class="btns">
      <a class="btn primary" href="<?= htmlspecialchars($shortUrl) ?>">Open in Ask The Word</a>
      <a class="btn ghost" href="<?= htmlspecialchars($appStore) ?>">Get the App</a>
    </div>
  </div>
</body>
</html>
