<?php
// ===============================
// Global config (no namespace)
// ===============================

// --- Database ---
define('DB_HOST', 'localhost');
define('DB_NAME', 'cp34267_snickity_go');     // <- verify
define('DB_USER', 'cp34267_go_user');         // <- verify
define('DB_PASS', 'Konikki$4242');            // <- verify

// --- Domains / API keys ---
define('SHORT_DOMAIN', 'https://go.snickitybit.com');  // no trailing slash

// Admin API key for server-side endpoints (NEVER ship in iOS app)
define('SECRET_API_KEY', '5f3b7d90b6c14f3f8f6d5e08b7a6a29df26f32a3a7cccf4b82a24b62a6a3f76d');

// **HMAC secret used to verify app-signed payloads**
// 32 random bytes, base64-encoded (generate on macOS):
//   python3 -c "import secrets,base64;print(base64.b64encode(secrets.token_bytes(32)).decode())"
define('HMAC_SECRET', '7BXo+/0wwt84o/iT7fqi++xbRG9K4NJ2B4iiaDpZY0Y=');  // e.g. 'x8dS1...'

// --- Limits ---
define('MAX_PAYLOAD_BYTES', 32768);  // 32 KB max JSON body

// ===============================
// PDO
// ===============================
function pdo(): PDO {
    static $pdo = null;
    if ($pdo instanceof PDO) return $pdo;

    $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4';
    try {
        $pdo = new PDO($dsn, DB_USER, DB_PASS, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
    } catch (Throwable $e) {
        http_response_code(500);
        header('Content-Type: application/json; charset=utf-8');
        header('Cache-Control: no-store');
        echo json_encode(['error' => 'DB connect failed', 'detail' => $e->getMessage()]);
        exit;
    }
    return $pdo;
}

// ===============================
// Helpers
// ===============================
function set_cors(): void {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization, X-API-Key');
}

function is_options(): bool {
    return (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS');
}

function json_input(): array {
    $raw = file_get_contents('php://input') ?: '';
    if (strlen($raw) > MAX_PAYLOAD_BYTES) {
        http_response_code(413);
        header('Content-Type: application/json; charset=utf-8');
        header('Cache-Control: no-store');
        echo json_encode(['error' => 'Payload too large']);
        exit;
    }
    $data = json_decode($raw, true);
    return is_array($data) ? $data : [];
}

function send_json(int $code, array $obj): void {
    http_response_code($code);
    header('Content-Type: application/json; charset=utf-8');
    header('Cache-Control: no-store');
    echo json_encode($obj, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

function require_api_key(): void {
    $hdr = $_SERVER['HTTP_X_API_KEY'] ?? '';
    if (!hash_equals(SECRET_API_KEY, $hdr)) {
        send_json(401, ['error' => 'Unauthorized']);
    }
}

function client_ip_bin(): ?string {
    $ip = $_SERVER['REMOTE_ADDR'] ?? '';
    if ($ip === '') return null;
    $bin = @inet_pton($ip);
    return ($bin === false) ? null : $bin;
}

function base62_random_id(int $len = 8): string {
    $alphabet = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $bytes = random_bytes($len);
    $out = '';
    for ($i = 0; $i < $len; $i++) {
        $out .= $alphabet[ord($bytes[$i]) % 62];
    }
    return $out;
}

function is_valid_id(string $id): bool {
    return (bool)preg_match('/^[A-Za-z0-9_-]{4,32}$/', $id);
}

function to_sql_datetime(?string $iso8601): ?string {
    if ($iso8601 === null || $iso8601 === '') return null;
    try {
        $dt = new DateTimeImmutable($iso8601);
        return $dt->setTimezone(new DateTimeZone('UTC'))->format('Y-m-d H:i:s');
    } catch (Throwable $e) {
        return null;
    }
}

function now_sql(): string {
    return (new DateTimeImmutable('now', new DateTimeZone('UTC')))->format('Y-m-d H:i:s');
}
