<?php
require __DIR__ . '/../config.php';
set_cors();
if (is_options()) exit(0);
require_api_key();

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
    send_json(405, ['error' => 'Method not allowed']);
}

$in = json_input();

// Validate payload
if (!isset($in['payload']) || !is_array($in['payload'])) {
    send_json(400, ['error' => 'Missing payload object']);
}
$payload_json = json_encode($in['payload'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
if ($payload_json === false) {
    send_json(400, ['error' => 'Invalid payload JSON']);
}
if (strlen($payload_json) > MAX_PAYLOAD_BYTES) {
    send_json(413, ['error' => 'Payload too large']);
}

// Optional id
$id = $in['id'] ?? null;
if ($id !== null) {
    if (!is_string($id) || !is_valid_id($id)) {
        send_json(400, ['error' => 'Invalid id format']);
    }
}

// Optional expiresAt (ISO 8601)
$expiresAt = $in['expiresAt'] ?? null;
$sql_expires = to_sql_datetime(is_string($expiresAt) ? $expiresAt : null);

$db = pdo();

// Generate unique id if not provided
if ($id === null) {
    for ($attempt = 0; $attempt < 5; $attempt++) {
        $candidate = base62_random_id(8);
        $stmt = $db->prepare('SELECT id FROM links WHERE id = ?');
        $stmt->execute([$candidate]);
        if (!$stmt->fetch()) { $id = $candidate; break; }
    }
    if ($id === null) {
        send_json(500, ['error' => 'Could not generate unique id']);
    }
} else {
    // Ensure not taken
    $stmt = $db->prepare('SELECT id FROM links WHERE id = ?');
    $stmt->execute([$id]);
    if ($stmt->fetch()) {
        send_json(409, ['error' => 'ID already exists']);
    }
}

// Insert
$stmt = $db->prepare(
  'INSERT INTO links (id, payload_json, status, created_at, created_ip, expires_at, clicks, last_access)
   VALUES (?, ?, "active", ?, ?, ?, 0, NULL)'
);
$stmt->execute([
    $id,
    $payload_json,
    now_sql(),
    client_ip_bin(),
    $sql_expires
]);

send_json(200, [
    'id' => $id,
    'shortUrl' => SHORT_DOMAIN . '/s/' . $id,
    'expiresAt' => $sql_expires
]);
