<?php
// File: /home/.../public_html/go.snickitybit.com/api/ping.php
require __DIR__ . '/../config.php';
set_cors();
if (is_options()) exit(0);

// Only allow GET/HEAD
$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
if (!in_array($method, ['GET', 'HEAD'], true)) {
    send_json(405, ['error' => 'Method not allowed']); // also sets Content-Type
}

// Require a valid API key. This should check the incoming header "X-API-Key".
require_api_key(); // <-- your existing auth gate

// If HEAD, return headers only with 200 OK, no body.
if ($method === 'HEAD') {
    header('Content-Type: application/json; charset=UTF-8');
    http_response_code(200);
    exit;
}

// GET: return a tiny JSON
send_json(200, ['ok' => true, 'ts' => gmdate('c')]);
